# OpenCart


## Overview

OpenCart is a free open source ecommerce platform for online merchants. OpenCart provides a professional and reliable foundation from which to build a successful online store.

## Reporting a bug
	
Read the instructions below before you create a bug report.
 
 1. Search the [OpenCart forum](http://forum.opencart.com/viewforum.php?f=161), ask the community if they have seen the bug or know how to fix it.
 2. Check all open and closed issues on the [GitHub bug tracker](https://github.com/opencart/opencart/issues).
 3. If your bug is related to the OpenCart core code then please create a bug report on GitHub.
 4. READ the [changelog for the master branch](https://github.com/opencart/opencart/blob/master/changelog.md)
 5. Use [Google](http://www.google.com) to search for your issue.
 6. Make sure that your bug/issue is not related to your hosting environment.
 
If you are not sure about your issue, it is always best to ask the community on our [bug forum thread](http://forum.opencart.com/viewforum.php?f=161&sid=f5208eb3888b13a5065be051362daa0d)

**Important!**
- If your bug report is not related to the core code (such as a 3rd party module or your server configuration) then the issue will be closed without a reason. You must contact the extension developer, use the forum or find a commercial partner to resolve a 3rd party code issue.
- If you would like to report a serious security bug please PM an OpenCart moderator/administrator on the forum. Please do not report concept/ideas/unproven security flaws - all security reports are taken seriously but you must include the EXACT details steps to reproduce it. Please DO NOT post security flaws in a public location.

## Making a suggestion

Please do not create a bug report if you think something needs improving / adding (such as features or change to code standards etc).

We welcome public suggestions on our [User Voice site](http://opencart.uservoice.com). 

## How to contribute

Fork the repository, edit and [submit a pull request](https://github.com/opencart/opencart/wiki/Creating-a-pull-request).

Please be very clear on your commit messages and pull request, empty pull request messages may be rejected without reason.

Your code standards should match the [OpenCart coding standards](https://github.com/opencart/opencart/wiki/Coding-standards). We use an automated code scanner to check for most basic mistakes - if the test fails your pull request will be rejected.

## How to install

Please read the installation instructions included in the repository.

## License

[GNU General Public License version 3 (GPLv3)](https://github.com/opencart/opencart/blob/master/license.txt)

## Links

- [OpenCart homepage](http://www.opencart.com/)
- [OpenCart forums](http://forum.opencart.com/)
- [OpenCart blog](http://www.opencart.com/index.php?route=feature/blog)
- [How to documents](http://docs.opencart.com/)
- [Newsletter](http://newsletter.opencart.com/h/r/B660EBBE4980C85C)
- [User Voice suggestions](http://opencart.uservoice.com)
